EvaluateScript("police.js");
EvaluateScript("input.js");
EvaluateScript("spawns.js");
EvaluateScript("hud.js");
EvaluateScript("list.js");
EvaluateScript("win.js");
EvaluateScript("audio.js");

var font = GetSystemFont();
var font2 = GetSystemFont();

font.setColorMask(CreateColor(0,0,0,255));

function game()
{
	Intro();
}

function Intro()
{
var xoff = -10;
var yoff = 0;
	while(IsKeyPressed(KEY_ENTER) == false)
	{
		font2.drawZoomedText(20,0, 2,"EMERGENCY RIOT");
		font2.drawZoomedText(190,20, 2,"RESPONSE!");
	
		font2.drawText(20+xoff,60+yoff, "Use LEFT-CLICK to select a police squad.");
		font2.drawText(20+xoff,80+yoff+5, "Use LEFT-CLICK to move the selected squad");
		font2.drawText(20+xoff,90+yoff+5, "  (and push any protesters in the way).");

		font2.drawText(20+xoff,110+yoff+10, "Use RIGHT-CLICK to move the selected squad");
		font2.drawText(20+xoff,120+yoff+10, "  (and detain any protesters in the way).");
	
		font2.drawText(20+xoff,140+yoff+15, "Stop rioters from doing too much damage,");
		font2.drawText(20+xoff,150+yoff+15, "  or getting into the security zone.");
	
		font2.drawText(20+xoff,170+yoff+20, "Detain too many protesters and the public");
		font2.drawText(20+xoff,180+yoff+20, "   outcry will get you fired!");
	
	
		font2.drawText(90,220, "Press ENTER to start!");

	
		FlipScreen();
	}





	SetDefaultMapScript(SCRIPT_ON_ENTER_MAP, "MainLoop();");
	MapEngine("map.rmp",60);

}

var g_dam_goal = 0;
var g_dam_tile = 0;
var g_timer_max = 4000;

var g_frames = 0;
function MainLoop()
{
	while(AreKeysLeft())
		GetKey();
		
	PlayMusic();
	SetupMap();
	DefineSpawns();
	g_dam = 0;

	g_dam_goal = 0;
	g_dam_tile = 0;
	
	g_frames=0;

	var framerate = 30;
	var last_time = GetTime();

	while(true)
	{
		while(GetTime()-last_time < framerate)
		{
			RenderMap();
			DrawPeeps();
			DrawPolice();
			DrawOver();
			DrawHud();
			DrawMouse();
			FlipScreen();
		}

		last_time = GetTime();
		GetInput();
		UpdatePolice();
		UpdatePeeps();
		UpdateSpawns();
 		g_frames++;
	
		if (g_frames > g_timer_max)
			Win();
		if (g_force>g_force_max)
			Lose(0);
		if (g_dam>g_dam_max)
			Lose(1);
	
		if (IsKeyPressed(KEY_ESCAPE) == true)
			return;
	}




}

var pstring = "";



var mouse = LoadImage("mouse.png");

function DrawMouse()
{
	mouse.blit(GetMouseX(), GetMouseY());
}


function SetupMap()
{
	for (i=0;i<20;i++)
	{
		for (j=0;j<15;j++)
		{
			mapy[i][j].hp = max_tile_hp;
		}
	}

	for (i=0;i<max_peeps;i++)
	{

		for (k=0;k<10;k++)
		{

			peeps[i].x = Math.floor(Math.random()*320);
			peeps[i].y = Math.floor(Math.random()*120);

			if (GetTile(Math.floor(peeps[i].x/16),Math.floor(peeps[i].y/16), 0) != 1)
			{
				peeps[i].x = -1;
				peeps[i].y = -1;
			}
			else
				k=10;
		}
	}

}

var g_overlay = LoadImage("map_over.png");

function DrawOver()
{
	g_overlay.blit(0,0);
}